
/*:

@target MZ
@plugindesc 早送りを禁止にできます。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_BanFastForward.js

プラグインコマンドで早送りの禁止をONにすると、
イベントの移動などの早送りができなくなります。
OFFにすると、早送りができるようになります。


@command fastForward
@text 早送りの禁止
@desc 早送りの禁止をするか変更できます。

@arg ban
@text 禁止
@desc 早送りの禁止をするか変更できます。
@type boolean
@default true

*/

/////////////////グローバルデータ/////////////////
var mk_banFastForward = null;


/////////////////早送り禁止にするかのデータ/////////////////

function MK_BanFastForward() {
    this.ban = false;
}

MK_BanFastForward.prototype.Ban = function(ban) {
    this.ban = ban;
};


(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_BanFastForward";
    
    //----------プラグインコマンド----------

    //早送りの禁止
    PluginManager.registerCommand(pluginName, "fastForward", args => {
        mk_banFastForward.Ban((args.ban == "true") ? true : false);
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------マップシーン----------
    
    const _Scene_Map_isFastForward = Scene_Map.prototype.isFastForward;
    Scene_Map.prototype.isFastForward = function() {
        if(!mk_banFastForward.ban){
           return _Scene_Map_isFastForward.apply(this, arguments);
        }
        return false;
    };
    
    
    //----------セーブ関係----------
    
    //ゲーム開始時作成データ
    const _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function() {
        _DataManager_createGameObjects.apply(this, arguments);
        mk_banFastForward = new MK_BanFastForward();
    };
    
    //セーブ
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function() {
        let contents = _DataManager_makeSaveContents.apply(this, arguments);
        contents.mk_banFastForward = mk_banFastForward;
        return contents;
    };
    
    //ロード
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents) {
        _DataManager_extractSaveContents.apply(this, arguments);
        mk_banFastForward = contents.mk_banFastForward;
    };
    
})();
